﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.tcap
{
    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/tcap/tcap_OperationModeTypes.h>")]
    public struct OperationMode
    {
    }
}

namespace nn.tcap.server
{
    [CppRefPath("<nn/tcap/server/tcap_IManager.sfdl.h>")]
    interface IManager : IServiceObject
    {
        [MethodId(0)]
        Result GetContinuousHighSkinTemperatureEvent(Out<NativeHandle> pOutHandle);

        [MethodId(1)]
        Result SetOperationMode(OperationMode operationMode);

        [MethodId(2)]
        Result LoadAndApplySettings();
    }
}
