﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include "tcap_SettingsHolder.h"

namespace nn { namespace tcap { namespace server {

SettingsHolder::SettingsHolder() NN_NOEXCEPT
    : m_ContinuousHighSkinTemperatureMilliSeconds(28800000)
    , m_ThermalBurnPreventionModeEnabled(true)
{
    // 何も処理しません。
}

void SettingsHolder::LoadSettings() NN_NOEXCEPT
{
    ReadSetting(&m_ContinuousHighSkinTemperatureMilliSeconds, "continuous_high_skin_temperature_milli_seconds");
    ReadSetting(&m_ThermalBurnPreventionModeEnabled, "thermal_burn_prevention_mode_enabled");
}

int SettingsHolder::GetContinuousHighSkinTemperatureMilliSeconds() NN_NOEXCEPT
{
    return m_ContinuousHighSkinTemperatureMilliSeconds;
}

bool SettingsHolder::IsThermalBurnPreventionModeEnabled() NN_NOEXCEPT
{
    return m_ThermalBurnPreventionModeEnabled;
}

}}} // namespace nn::tcap::server
