﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/os/os_SystemEvent.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/tcap/server/tcap_Api.h>
#include <nn/tcap/server/tcap_IManager.sfdl.h>
#include <nn/tcap/server/tcap_ManagerImpl.h>
#include <nn/tcap/tcap_OperationModeTypes.h>

#include "tcap_ThermalCoordinatorAdvancedPolicy.h"

namespace nn { namespace tcap { namespace server {

nn::Result ManagerImpl::GetContinuousHighSkinTemperatureEvent(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT
{
    nn::os::NativeHandle internalHandle = nn::os::GetReadableHandleOfSystemEvent(nn::tcap::server::GetContinuousHighSkinTemperatureEvent());
    *pOutHandle = nn::sf::NativeHandle(internalHandle, false);
    NN_RESULT_SUCCESS;
}

nn::Result ManagerImpl::SetOperationMode(OperationMode operationMode) NN_NOEXCEPT
{
    nn::tcap::server::SetOperationMode(operationMode);
    NN_RESULT_SUCCESS;
}

nn::Result ManagerImpl::LoadAndApplySettings() NN_NOEXCEPT
{
    nn::tcap::server::LoadAndApplySettings();
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::tcap::server
