﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/tc/impl/tc.h>
#include <nn/tc/impl/tc_PowerModeTypes.h>

#include "tc_Constants.h"

namespace nn { namespace tc { namespace impl {

void Initialize() NN_NOEXCEPT
{
    ;
}

void Finalize() NN_NOEXCEPT
{
    ;
}

nn::Result SetOperatingMode(OperatingMode operatingMode) NN_NOEXCEPT
{
    NN_UNUSED(operatingMode);
    NN_RESULT_SUCCESS;
}

nn::Result GetEventPtr(nn::os::SystemEventType** pOutEventPtr, EventTarget target) NN_NOEXCEPT
{
    NN_UNUSED(pOutEventPtr);
    NN_UNUSED(target);
    NN_RESULT_SUCCESS;
}

nn::Result IsActionAllowed(bool* pOutPossible, Action action) NN_NOEXCEPT
{
    NN_UNUSED(pOutPossible);
    NN_UNUSED(action);
    NN_RESULT_SUCCESS;
}

nn::Result EnableVirtualTemperature(Location location) NN_NOEXCEPT
{
    NN_UNUSED(location);
    NN_RESULT_SUCCESS;
}

nn::Result DisableVirtualTemperature(Location location) NN_NOEXCEPT
{
    NN_UNUSED(location);
    NN_RESULT_SUCCESS;
}

nn::Result SetVirtualTemperature(Location location, TemperatureMilliC temperature) NN_NOEXCEPT
{
    NN_UNUSED(location);
    NN_UNUSED(temperature);
    NN_RESULT_SUCCESS;
}

void Update() NN_NOEXCEPT
{
    ;
}

void SetPowerMode(PowerMode powerMode) NN_NOEXCEPT
{
    NN_UNUSED(powerMode);
}

nn::Result EnableFanControl() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result DisableFanControl() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result IsFanControlEnabled(bool* pOutEnabled) NN_NOEXCEPT
{
    NN_UNUSED(pOutEnabled);
    NN_RESULT_SUCCESS;
}

TemperatureMilliC GetSkinTemperatureMilliC() NN_NOEXCEPT
{
    return DefaultSkinTemperatureMilliC;
}

}}} // namespace nn::tc::impl
