﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/tc/tc_Types.h>
#include <nn/tc/impl/tc_PowerMode.h>
#include <nn/ts.h>

namespace nn { namespace tc { namespace impl { namespace detail {

class LocationAccessor {

public:
    explicit LocationAccessor(nn::ts::Location location)
    : m_VirtualTemperature(DefaultVirtualTemperature),
      m_VirtualTemperatureEnabled(false),
      m_Location(location)
    {
        ;
    }
    virtual void Initialize() NN_NOEXCEPT;
    virtual void Finalize() NN_NOEXCEPT;
    virtual nn::Result GetTemperature(TemperatureMilliC* pOutTemperature) NN_NOEXCEPT;
    virtual nn::Result GetRealTemperature(TemperatureMilliC* pOutTemperature) NN_NOEXCEPT;
    virtual void SetVirtualTemperature(TemperatureMilliC temperature) NN_NOEXCEPT;
    virtual void SetVirtualTemperatureEnabled(bool enabled) NN_NOEXCEPT;
    virtual void SetPowerMode(PowerMode powerMode) NN_NOEXCEPT;

private:
    const int DefaultVirtualTemperature = 48;

    TemperatureMilliC m_VirtualTemperature;
    bool m_VirtualTemperatureEnabled;
    nn::ts::Location m_Location;
};

}}}} // namespace nn::tc::impl::detail
