﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ahid/hdr/hdr.h>
#include <nn/ahid/ahid.h>

namespace nn {
namespace stdfu {

const int DfuIntrruptDataSize = 64;

class AhidDevice
{
public:

    Result ChangeToDfuDevice(nn::ahid::Ahid *pAhid) NN_NOEXCEPT;
    Result ChangeToDfuDevice(uint16_t vid, uint16_t pid, uint16_t bcd) NN_NOEXCEPT;

private:

    Result GetHdrDevice(nn::ahid::hdr::DeviceParameters *pDeviceParameters, uint16_t vid, uint16_t pid, uint16_t bcd) NN_NOEXCEPT;
};

} // namespace stdfu
} // namespace nn
