﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/ssl/detail/ssl_Common.h>
#include "ssl_BdfReader.h"

namespace nn { namespace ssl { namespace detail {

//////////////////////////////////////////////////////////////////////////////
//  StaticDataReader - BDF data reader based on BDF located in static
//  compiled data area.
//////////////////////////////////////////////////////////////////////////////
class StaticDataReader : public BdfReader
{
private:
    const uint8_t                                   *m_pData;
    const uint32_t                                  m_dataLen;

public:
    StaticDataReader(const uint8_t *pData, const uint32_t dataLen);
    ~StaticDataReader();

    virtual nn::Result Open() NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::Result Read(size_t   *pOutBytesRead,
                            int64_t  offset,
                            uint8_t  *pOutBuf,
                            size_t   size) NN_NOEXCEPT NN_OVERRIDE;
};

} } }    //  nn::ssl::detail
