﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/ssl/detail/ssl_Common.h>
#include <nn/ssl/ssl_CaCertificateId.h>
#include <nn/ssl/detail/ssl_BuiltinDataInfo.h>

#include "ssl_CertStore.h"
#include "ssl_NssCommon.h"
#include "ssl_NssCore.h"
#include "ssl_BdfReader.h"
#include "plhash.h"

namespace nn { namespace ssl { namespace detail {

class TcfNullLoader : public BuiltinDataLoader
{
public:
    TcfNullLoader();
    ~TcfNullLoader();
    uint32_t GetDataBufSize();
    int Load(uint8_t *pOutBuf, uint32_t maxBufSize, uint32_t *pOutDataSize);
};


class TcfSourceLoader : public BuiltinDataLoader
{
private:
    BdfMetaDataEntry            m_CertEntry;

public:
    NN_IMPLICIT TcfSourceLoader(BdfMetaDataEntry *pCertEntry) NN_NOEXCEPT;
    uint32_t GetDataBufSize();
    int Load(uint8_t *pOutBuf, uint32_t maxBufSize, uint32_t *pOutDataSize);
};


class NssSourceLoader : public BuiltinDataLoader
{
private:
    CERTCertificate             *m_pCert;

public:
    NN_IMPLICIT NssSourceLoader(CERTCertificate *pCert) NN_NOEXCEPT;
    ~NssSourceLoader();
    uint32_t GetDataBufSize();
    int Load(uint8_t *pOutBuf, uint32_t maxBufSize, uint32_t *pOutDataSize);
};


class TrustedCertManager
{
    friend class TcfSourceLoader;

    struct TcmIdInfo
    {
        uint64_t                maxIds;
        CaCertificateId         *pIdBuf;
    };

private:
    static const char                               *g_RootCaTrust;
    static const char                               *g_IntermediateCaTrust;
    static const uint64_t                           g_CertStoreFakePid = 0;

    static TrustedCertManager                       *g_pInstance;
    static nn::os::Mutex                            g_Lock;

    uint32_t                                        m_TcCount;
    PLHashTable                                     *m_pTcHashTbl;
    CertStore                                       *m_pCertStore;

    TrustedCertManager(PLHashTable  *pTcHashTbl,
                       CertStore    *pCertStore);
    ~TrustedCertManager();

    nn::Result ImportTrustedCert(CERTCertificate   **pOutCert,
                                 BdfMetaDataEntry  *pInCertEntry,
                                 BdfReader         *pReader);

    nn::Result ProcessTrustedCertsFile();

    BuiltinDataInfo *FindTrustedCertInfo(CaCertificateId id);

    nn::Result CreateTrustedCertInfo(BuiltinDataInfo  **pOutCertInfo,
                                     BdfReader        *tcf,
                                     uint32_t         certIdx);

    static PLHashNumber GenHashFromId(const void *key);

    static NssCore::InitStatus TcmDeferredInitCb(void *pInArg);

    static PRIntn TcmHashEnumerator(PLHashEntry *pEntry, PRIntn i, void *pArg);

    static void TcmAscSortIdArray(CaCertificateId *pArray, int arraySize);

public:
    static const char                               *g_TcmDeferredInitId;

    static nn::Result Initialize();
    static nn::Result Finalize();
    static nn::Result GetTrustedCertInfo(BuiltinDataInfo  **pOutTci,
                                         CaCertificateId  id);
    static bool IsAllId(CaCertificateId id);
    static nn::Result GetAllIds(CaCertificateId **pOutIds, uint32_t *pOutNumIds);
};

} } }    //  nn::ssl::detail
