﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/ssl/detail/ssl_Build.h>
#include "ssl_NssCommon.h"
#include "ssl_Util.h"

namespace nn { namespace ssl { namespace detail {


class NssConfigurator
{
public:

    // --------------------------------------------------------------------------------------------
    // Initializer
    // --------------------------------------------------------------------------------------------
    class Initializer
    {
    public:
        enum CipherPolicyRegion
        {
            CipherPolicyRegion_Invalid = 0x00,
            CipherPolicyRegion_US      = 0x01,
            CipherPolicyRegion_FR      = 0x02,
            CipherPolicyRegion_Export  = 0x03,
        };

        static nn::Result  SetDefaultOptions();
        static nn::Result  SetDefaultCipherPreference();
        static nn::Result  SetDefaultCipherPolicy(CipherPolicyRegion region);
        static const char* GetConfigDir();

        class Pkcs12ModuleConfigurator
        {
        public:
            static SECStatus SwapUnicodeBytes(SECItem *pOutUnicodeItem);
            static PRBool ConvertUnicodeToAscii(
                PRBool        toUnicode,
                unsigned char *inBuf,
                unsigned int  inBufLen,
                unsigned char *outBuf,
                unsigned int  maxOutBufLen,
                unsigned int  *outBufLen,
                PRBool        swapBytes);
            static nn::Result Initialize();
        };
    };
};

}}}
