﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "ssl_NssConfigurator.h"

namespace nn { namespace ssl { namespace detail {

namespace
{
    // Buffer to keep a config path extended with unique 24 character length ID plus character trailing '\0' character
    static char g_NssConfigDirPath[] = "/siglo/ssl000000000000000000000000";
    // Length of "/siglo/ssl" substring which is a constant part of the directory name
    static const int g_DirConstPartLength = 10;
    static bool g_IsInitialized = false;
}

const char* NssConfigurator::Initializer::GetConfigDir()
{
    // Generate a unique path if g_NssConfigDirPath is not initialized yet. Combination of Windows Process ID and system time uses as a unique part of the path.
    if (!g_IsInitialized)
    {
        FILETIME ft;
        GetSystemTimeAsFileTime(&ft);
        sprintf(&g_NssConfigDirPath[g_DirConstPartLength], "%08x%x%x", GetCurrentProcessId(), ft.dwLowDateTime, ft.dwHighDateTime);
        g_IsInitialized = true;
    }

    return (const char*)g_NssConfigDirPath;
}

}}}
