﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/ssl/ssl_Types.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/ssl/detail/ssl_ISslService.h>

using namespace nn::sf;
using namespace nn::ssl::sf;


namespace nn { namespace ssl { namespace detail {

class ServiceSession
{
private:
    static SharedPointer<ISslService>   g_ServiceSession;

public:
    static const uint32_t       g_MaxSessions = nn::ssl::MaxContextCount / 2;
    static const uint32_t       g_SessionPorts = 1;

    static nn::Result Initialize(uint32_t numSessions);
    static void Finalize();
    static bool IsInitialized();

    static SharedPointer<ISslService> *GetServiceSession();
};

} } }
