﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "detail/ssl_ISslServiceFactory.h"
#include "detail/ssl_ISslServiceDfcFactory.h"

namespace nn { namespace ssl { namespace detail {

nn::Result ISslServiceFactory::Initialize(uint32_t maxConcurTrans) NN_NOEXCEPT
{
    NN_UNUSED(maxConcurTrans);
    return ResultSuccess();
}


nn::Result ISslServiceFactory::Finalize() NN_NOEXCEPT
{
    return ResultSuccess();
}


nn::Result ISslServiceFactory::CreateISslService(SharedPointer<ISslService> *pOut) NN_NOEXCEPT
{
    nn::Result                  ret;
    ISslServiceDfcFactory       dfcFactory;

    //  On Win32 there is no separate SSL process, so just create a DFC
    //  version of the interface.
    ret = dfcFactory.CreateISslService(pOut);
    return ret;
}

} } }
