﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "detail/ssl_ISslServiceFactoryBase.h"

namespace nn { namespace ssl { namespace detail {

class ISslServiceFactory : ISslServiceFactoryBase
{
public:
    // The version of ISslService
    // It is used in the server side to distinguish the version of the client
    // ---------+----------------------------------------------------------------------------------
    // Version# | Description
    // ---------+----------------------------------------------------------------------------------
    // 0        | Before 3.0.0 NUP (this field doesn't exist in these versions of the interface
    //          | thus 0 would be set automatically in the server side
    // ---------+----------------------------------------------------------------------------------
    // 1        | 3.0.0 NUP
    // ---------+----------------------------------------------------------------------------------
    // 2        | 5.0.0 NUP
    // ---------+----------------------------------------------------------------------------------
    enum ISslServiceVersionType
    {
        ISslServiceVersionType_Launch = 0,
        ISslServiceVersionType_Nup300 = 1,
        ISslServiceVersionType_Nup500 = 2
    };

    static const uint32_t ISslServiceVersion = ISslServiceVersionType_Nup500;

    static nn::Result Initialize(uint32_t maxConcurTrans) NN_NOEXCEPT;
    static nn::Result Finalize() NN_NOEXCEPT;
    nn::Result CreateISslService(SharedPointer<ISslService> *pOut) NN_NOEXCEPT;
};

} } }
