﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/ssl/detail/ssl_BuiltinDataInfo.h>

namespace nn { namespace ssl { namespace detail {

BuiltinDataInfo::BuiltinDataInfo(uint32_t                            id,
                                 BuiltinDataInfo::BuiltinDataStatus  status,
                                 const char                          *pName,
                                 BuiltinDataLoader                   *pLoader) :
    m_Id(id),
    m_Status(status),
    m_pName(pName),
    m_pLoader(pLoader)
{
}

BuiltinDataInfo::~BuiltinDataInfo()
{
}


uint32_t BuiltinDataInfo::GetId()
{
    return m_Id;
}


BuiltinDataInfo::BuiltinDataStatus BuiltinDataInfo::GetStatus()
{
    return m_Status;
}


const char *BuiltinDataInfo::GetName()
{
    return m_pName;
}


int BuiltinDataInfo::GetData(uint8_t *pOutData, uint32_t bufSize, uint32_t *pOutDataSize)
{
    int                         ret = 0;

    ret = m_pLoader->Load(pOutData, bufSize, pOutDataSize);

    return ret;
}


uint32_t BuiltinDataInfo::GetDataSize()
{
    return m_pLoader->GetDataBufSize();
}

} } }    //  namespace nn::ssl::detail
