﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/init.h>
#include <nn/mem.h>

#include <nn/nn_SdkLog.h>
#include <nn/ssl/detail/ssl_Common.h>
#include <nn/ssl/detail/ssl_Build.h>
#include <nn/ssl/detail/ssl_Log.h>
#include <nn/ssl/ssl_Types.h>

#ifndef NN_DETAIL_SSL_ENABLE_PROCESS_DEBUG
#error 'This file must not be used unless the debug flag is defined'
#endif


// ------------------------------------------------------------------------------------------------
// Macros
// ------------------------------------------------------------------------------------------------

namespace nn { namespace ssl { namespace detail {

// ------------------------------------------------------------------------------------------------
// Forward declaration
// ------------------------------------------------------------------------------------------------
class DebugUtil;

// ------------------------------------------------------------------------------------------------
// DebugSessionCache
// ------------------------------------------------------------------------------------------------
class DebugSessionCache
{
private:
    static const int DumpMsecInterval = 5000; //!< Timer granularity for dump

    bool         m_IsDumpStats;
    DebugUtil*   m_pDebugUtilObj;
    nn::os::Tick m_lastDumpTick;

public:
    DebugSessionCache();
    ~DebugSessionCache();

    void Initialize(DebugUtil* pInUtilObj);
    void Finalize();

    void ConfigurePeriodicDump(bool enable);
    void Dump();
    void RunScheduler();
};

}}}
