﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/srepo/srepo_StateNotifier.h>
#include <nn/srepo/detail/srepo_ApiDetail.h>
#include <nn/srepo/detail/srepo_ShimLibraryGlobal.h>

namespace nn { namespace srepo {

void NotifyUserList(const nn::account::Uid users[], int count) NN_NOEXCEPT
{
    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        session->NotifyUserList(sf::InArray<nn::account::Uid>(users, static_cast<size_t>(count))));
}
void NotifyUserDeleted(const nn::account::Uid& uid) NN_NOEXCEPT
{
    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();
    auto result = detail::HandleSaveResult(session->NotifyUserDeleted(uid));
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}
void NotifyUserRegistered(const nn::account::Uid& uid) NN_NOEXCEPT
{
    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();
    auto result = detail::HandleSaveResult(session->NotifyUserRegistered(uid));
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}
void NotifyUserClosed(const nn::account::Uid& uid) NN_NOEXCEPT
{
    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();
    auto result = detail::HandleSaveResult(session->NotifyUserClosed(uid));
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}
void NotifyUserOpened(const nn::account::Uid& uid) NN_NOEXCEPT
{
    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();
    auto result = detail::HandleSaveResult(session->NotifyUserOpened(uid));
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}

void NotifyCompletedNetworkRequestChanged(CompletedNetworkRequestType type) NN_NOEXCEPT
{
    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();
    auto result = detail::HandleSaveResult(session->NotifyCompletedNetworkRequestChanged(static_cast<int8_t>(type)));
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}

void NotifyFriendPresenceChanged(const nn::account::Uid& uid, FriendPresence state) NN_NOEXCEPT
{
    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();
    auto result = detail::HandleSaveResult(session->NotifyFriendPresenceChanged(uid, static_cast<int8_t>(state)));
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}

void NotifyNotificationConnectivityChanged(NotificationConnectivity state) NN_NOEXCEPT
{
    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();
    auto result = detail::HandleSaveResult(session->NotifyNotificationConnectivityChanged(static_cast<int8_t>(state)));
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}

void NotifyDeviceOperationModeChanged(DeviceOperationMode mode) NN_NOEXCEPT
{
    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();
    auto result = detail::HandleSaveResult(session->NotifyDeviceOperationModeChanged(static_cast<int8_t>(mode)));
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}

void NotifySystemPowerStateChanged(SystemPowerState state) NN_NOEXCEPT
{
    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();
    auto result = detail::HandleSaveResult(session->NotifySystemPowerStateChanged(static_cast<int8_t>(state)));
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}

void NotifyForegroundProgramChanged(const nn::ncm::ProgramId& id) NN_NOEXCEPT
{
    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();
    auto result = detail::HandleSaveResult(session->NotifyForegroundProgramChanged(id));
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}

void NotifyControllerCountChanged(int8_t total, int8_t rail) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_GREATER_EQUAL(total, 0);
    NN_SDK_REQUIRES_GREATER_EQUAL(rail, 0);
    NN_SDK_REQUIRES_GREATER_EQUAL(total, rail);

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();
    auto result = detail::HandleSaveResult(session->NotifyControllerCountChanged(total, rail));
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}

}}
