﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/srepo/srepo_ApiAdmin.h>
#include <nn/srepo/srepo_Result.h>
#include <nn/srepo/detail/srepo_ShimLibraryGlobal.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace srepo {

nn::Result PopReport(ReportCategory* outCategory, nn::account::Uid* outUid, char* outEventIdBuffer, nn::ApplicationId* outAppId, size_t* outDataSize, void* outDataBuffer, size_t outEventIdBufferSize, size_t outDataBufferSize) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outCategory);
    NN_SDK_REQUIRES_NOT_NULL(outUid);
    NN_SDK_REQUIRES_NOT_NULL(outEventIdBuffer);
    NN_SDK_REQUIRES_NOT_NULL(outAppId);
    NN_SDK_REQUIRES_NOT_NULL(outDataSize);
    NN_SDK_REQUIRES_NOT_NULL(outDataBuffer);
    NN_SDK_REQUIRES_GREATER(outEventIdBufferSize, 0u);
    NN_SDK_REQUIRES_GREATER(outDataBufferSize, 0u);

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    int32_t category;
    int64_t dataSize;

    NN_RESULT_DO(session->PopReport(
        nn::sf::Out<int32_t>(&category),
        nn::sf::Out<nn::account::Uid>(outUid),
        nn::sf::OutArray<char>(outEventIdBuffer, outEventIdBufferSize),
        nn::sf::Out<nn::ApplicationId>(outAppId),
        nn::sf::Out<int64_t>(&dataSize),
        nn::sf::OutBuffer(static_cast<char*>(outDataBuffer), outDataBufferSize)
    ));

    *outCategory = static_cast<ReportCategory>(category);
    *outDataSize = static_cast<size_t>(dataSize);

    NN_RESULT_SUCCESS;
}

nn::Result RegisterPushEvent(nn::os::SystemEvent* pEvent, nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pEvent);

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    nn::sf::NativeHandle handle;
    NN_RESULT_DO(session->GetPushEventReadableHandle(&handle));

    pEvent->AttachReadableHandle(handle.GetOsHandle(), handle.IsManaged(), clearMode);
    handle.Detach();

    NN_RESULT_SUCCESS;
}

}}
