﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn
{
    [CppRefPath(@"<nn/nn_ApplicationId.h>")]
    [ExternalStruct(8, 8)]
    public struct ApplicationId
    {
    }
}

namespace nn.account
{
    [CppRefPath(@"<nn/account/account_Types.h>")]
    [ExternalStruct(16, 8)]
    public struct Uid
    {
    }
}

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_ProgramId.h>")]
    [ExternalStruct(8, 8)]
    public struct ProgramId
    {
    }
}

namespace nn.srepo.detail.ipc
{
    [CppRefPath(@"<nn/srepo/detail/ipc/srepo_ISrepoService.sfdl.h>")]
    public partial interface ISrepoService : IServiceObject {}

    ////////////////////////////////////////////////////////////////////////////////
    // Generic API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface ISrepoService : IServiceObject
    {
        [MethodId(10100)]
        Result SaveReport(InArray<char_t> eventId, nn.ApplicationId appId, InBuffer data);

        [MethodId(10101)]
        Result SaveReportWithUser(nn.account.Uid uid,
            InArray<char_t> eventId, nn.ApplicationId appId, InBuffer data);

        [MethodId(10200)]
        Result SaveReportForAntiPiracy(InArray<char_t> eventId, nn.ApplicationId appId, InBuffer data);

        [MethodId(10201)]
        Result SaveReportWithUserForAntiPiracy(nn.account.Uid uid,
            InArray<char_t> eventId, nn.ApplicationId appId, InBuffer data);

        // アカウント
        [MethodId(11000)]
        Result NotifyUserList(
            [Pre(@"_.GetLength() <= ::nn::account::UserCountMax")] InArray<nn.account.Uid> users);

        [MethodId(11001)]
        Result NotifyUserDeleted(nn.account.Uid uid);

        [MethodId(11002)]
        Result NotifyUserRegistered(nn.account.Uid uid);

        [MethodId(11003)]
        Result NotifyUserClosed(nn.account.Uid uid);

        [MethodId(11004)]
        Result NotifyUserOpened(nn.account.Uid uid);

        // ネットワーク接続状態
        [MethodId(11100)]
        Result NotifyCompletedNetworkRequestChanged(int8_t type);

        // フレンドプレゼンス
        [MethodId(11200)]
        Result NotifyFriendPresenceChanged(nn.account.Uid uid, int8_t state);

        // 通知
        [MethodId(11300)]
        Result NotifyNotificationConnectivityChanged(int8_t state);

        // 動作モード
        [MethodId(11400)]
        Result NotifyDeviceOperationModeChanged(int8_t mode);

        // パワーステート
        [MethodId(11500)]
        Result NotifySystemPowerStateChanged(int8_t state);

        // 起動プログラム
        [MethodId(11600)]
        Result NotifyForegroundProgramChanged(nn.ncm.ProgramId id);

        // コントローラ
        [MethodId(11700)]
        Result NotifyControllerCountChanged(int8_t total, int8_t rail);
    }

    ////////////////////////////////////////////////////////////////////////////////
    // Manager API
    ////////////////////////////////////////////////////////////////////////////////
    public partial interface ISrepoService : IServiceObject
    {
        [MethodId(20100)]
        Result PopReport(Out<int32_t> outCategory, Out<nn.account.Uid> outUid, OutArray<char_t> outEventId, Out<nn.ApplicationId> outAppId, Out<int64_t> outDataSize, OutBuffer outData);

        [MethodId(20200)]
        Result GetPushEventReadableHandle(Out<NativeHandle> outHandle);
    }
}
