﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.spsm
{
    [ExternalStruct(4, 4)]
    [CppRefPath("<nn/spsm/spsm_PowerStateTypes.h>")]
    public struct WakeReasonFlagSet
    {
    }

    [ExternalStruct(80, 8)]
    [CppRefPath(@"<nn/spsm/spsm_Debug.h>")]
    public struct SleepWakeSequenceAnalyzedData
    {
    }
}

namespace nn.spsm.detail
{
    [CppRefPath("<nn/spsm/detail/spsm_IPowerStateInterface.h>")]
    interface IPowerStateInterface : IServiceObject
    {
        [MethodId(0)]
        Result GetCurrentState(Out<int32_t> powerState);

        [MethodId(1)]
        Result EnterSleep(Out<NativeHandle> handle);

        [MethodId(2)]
        Result GetLastWakeReason(Out<WakeReasonFlagSet> wakeReason);

        [MethodId(3)]
        Result Shutdown(bool reboot);

        [MethodId(4)]
        Result GetNotificationMessageEventHandle(Out<NativeHandle> handle);

        [MethodId(5)]
        Result ReceiveNotificationMessage(Out<int32_t> Message);

        [MethodId(6)]
        Result AnalyzeLogForLastSleepWakeSequence(Out<SleepWakeSequenceAnalyzedData> outData);

        [MethodId(7)]
        Result ResetEventLog();

        [MethodId(8)]
        Result AnalyzePerformanceLogForLastSleepWakeSequence(nn.sf.OutBuffer outBuffer);

        [MethodId(9)]
        Result ChangeHomeButtonLongPressingTime(int64_t nanoSeconds);

        [MethodId(10)]
        Result PutErrorState();

        // 廃止欠番
        // [MethodId(11)]
        // Result InvalidateCurrentHomeButtonPressing(int64_t nanoSeconds);
    }
}
