﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include <nn/bpc/bpc_BoardPowerControl.h>
#include <nn/spsm/detail/spsm_Log.h>
#include "spsm_Shutdown.h"

namespace nn { namespace spsm { namespace server {

namespace {

    bool g_IsRebootEnabled = false;

}

void ShutdownSystem() NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    nn::bpc::InitializeBoardPowerControl();
    if (g_IsRebootEnabled)
    {
        nn::bpc::RebootSystem();
    }
    else
    {
        nn::bpc::ShutdownSystem();
    }
#else
    // スピンループでシャットダウンを表現するとテストしづらいので return
#endif
}

void SetRebootFlag(bool rebootEnabled) NN_NOEXCEPT
{
    bool alwaysReboot = false;
    settings::fwdbg::GetSettingsItemValue(&alwaysReboot, sizeof(alwaysReboot), "systempowerstate", "always_reboot");
    g_IsRebootEnabled = alwaysReboot ? true : rebootEnabled;
}

bool GetRebootFlag() NN_NOEXCEPT
{
    return g_IsRebootEnabled;
}

}}}

