﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/spsm/spsm_PowerStateTypes.h>
#include <nn/spsm/server/spsm_ServerTypes.h>
#include <nn/spsm/server/spsm_PowerStateMessageQueue.h>
#include "spsm_NotificationMessageQueue.h"
#include "spsm_PowerStateHandlerContext.h"
#include "spsm_IPowerStateHandler.h"

namespace nn { namespace spsm { namespace server {

    void InitializePowerStateHandlerImpl(PowerStateMessageQueue* pPowerStateMessageQueue, NotificationMessageQueue* pNotificationMessageQueue, nn::os::SystemEvent* pAwakeEvent, const PowerStateHandlerContext* pContext, const InitializeMode mode) NN_NOEXCEPT;
    IPowerStateHandler* GetPowerStateHandlerImpl(PowerState state) NN_NOEXCEPT;
    PowerState DetermineNextState(PowerState current, PowerState dest) NN_NOEXCEPT;
    void AbortAllPowerStateHandling() NN_NOEXCEPT;

}}}

