﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/spsm/spsm_PowerStateTypes.h>

namespace nn { namespace spsm { namespace server {

    struct PowerStateHandlerContext
    {
        PowerStateHandlerContext() NN_NOEXCEPT :
            previousState(),
            destinationState()
        {}

        PowerState previousState;    //!< 現在のステートの直前のステート
        PowerState destinationState; //!< 遷移の目的地となるステート。状態遷移が必要でない間は PowerState_None を格納します。
    };

}}}
