﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/spsm/spsm_Debug.h>
#include "spsm_Debug.h"
#include "spsm_PerformanceLog.h"

namespace nn { namespace spsm { namespace server {

namespace {

    int g_ValidDataCount = 0;

#if defined(NN_DETAIL_SPSM_ENABLE_PERFORMANCE_CHECK)
    nn::spsm::detail::PscTransition g_Data[MaxPscTransitionCount];
#endif

}

    void LogPscPerformance(nn::psc::PmControl* pPmControl) NN_NOEXCEPT
    {
#if defined(NN_DETAIL_SPSM_ENABLE_PERFORMANCE_CHECK)
        if (g_ValidDataCount >= MaxPscTransitionCount)
        {
            return;
        }

        auto p = &(g_Data[g_ValidDataCount]);

        auto result = pPmControl->GetModuleInformation(
            &(p->transitionInfo),
            &(p->moduleCount),
            p->moduleInfoList,
            sizeof(p->moduleInfoList) / sizeof(p->moduleInfoList[0]),
            &(p->dependencyCount),
            p->dependencyInfoList,
            sizeof(p->dependencyInfoList) / sizeof(p->dependencyInfoList[0])
        );

        NN_ABORT_UNLESS_RESULT_SUCCESS(result);

        g_ValidDataCount++;
#else
        NN_UNUSED(pPmControl);
#endif
    }

    void ResetPerformanceLog() NN_NOEXCEPT
    {
        g_ValidDataCount = 0;
    }

    void AnalyzePerformanceLogForLastSleepWakeSequence(SleepWakeSequencePerformanceData* pOutData) NN_NOEXCEPT
    {
#if defined(NN_DETAIL_SPSM_ENABLE_PERFORMANCE_CHECK)
        NN_SDK_ASSERT(sizeof(pOutData->data) == sizeof(g_Data));
        std::memcpy(pOutData->data, g_Data, sizeof(g_Data));
#endif

        pOutData->validDataCount = g_ValidDataCount;
    }

}}}

