﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_Common.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/os.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/spsm/spsm_Debug.h>
#include <nn/spsm/observer/spsm_Observer.h>
#include "spsm_EventHandlerManager.h"

namespace nn { namespace spsm { namespace observer {

    ObserverInterfaceImpl::ObserverInterfaceImpl() NN_NOEXCEPT
    {
    }

    Result ObserverInterfaceImpl::ChangeHomeButtonLongPressingTime(int64_t nanoSeconds) NN_NOEXCEPT
    {
        nn::spsm::observer::EventHandlerManager::GetInstance().ChangeHomeButtonLongPressingTime( TimeSpan::FromNanoSeconds(nanoSeconds) );
        NN_RESULT_SUCCESS;
    }

    void LoopEventHandler(nn::os::SystemEventType* pCecEventType) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(pCecEventType);
        nn::spsm::observer::EventHandlerManager::GetInstance().EventHandlerLoopAutoImpl(pCecEventType);
    }

#if defined(NN_BUILD_CONFIG_OS_WIN)
    void StopEventHandler() NN_NOEXCEPT
    {
        nn::spsm::observer::EventHandlerManager::GetInstance().StopEventHandlerLoopAutoImpl();
    }
#endif

}}}

