﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/os/os_MultipleWait.h>
#include <nn/bgtc/bgtc_StateControlApi.h>

#include "spsm_BackgroundTask.h"

namespace nn { namespace spsm { namespace observer {

//-----------------------------------------------------------------------------
//  初期化
//
void BackgroundTask::Initialize(nn::spsm::server::PowerStateMessageQueue* pPowerStateMessageQueue) NN_NOEXCEPT
{
    m_pPowerStateMessageQueue = pPowerStateMessageQueue;

    NN_ABORT_UNLESS_RESULT_SUCCESS(
        bgtc::InitializeStateControl()
    );
    os::InitializeMultiWaitHolder(&m_StateChangeEventHolder, bgtc::GetStateChangedEvent().GetBase());

    m_StateChangeEventHolder.userData   = reinterpret_cast<uintptr_t>(this);

}


//-----------------------------------------------------------------------------
//  デストラクタ
//
void BackgroundTask::Finalize() NN_NOEXCEPT
{
    os::FinalizeMultiWaitHolder(&m_StateChangeEventHolder);
    nn::bgtc::FinalizeStateControl();
}

//-----------------------------------------------------------------------------
//
//
void BackgroundTask::ProcessStateChange() NN_NOEXCEPT
{
    bgtc::GetStateChangedEvent().Clear();

    if (bgtc::GetState() == bgtc::State_Idle)
    {
        // NN_DETAIL_SPSM_INFO_V1("bgtc is Idle. Leaving MinimumAwake_ForBackgroundTask\n");
        NotifyBackgroundTaskDone();
    }
}

void BackgroundTask::NotifyEnteringBackgroundTask() NN_NOEXCEPT
{
    // 別スレッドから呼ばれるが同期不要
    // BGTC に半起床開始を通知
    bgtc::NotifyEnteringHalfAwake();
}

void BackgroundTask::NotifyLeavingBackgroundTask() NN_NOEXCEPT
{
    // 別スレッドから呼ばれるが同期不要
    // BGTC に半起床終了を通知（現状は何もしない）
    bgtc::NotifyLeavingHalfAwake();
}

//-----------------------------------------------------------------------------
//
//

//-----------------------------------------------------------------------------

}}} // namespace nn::spsm::observer

