﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.ncm
{
    [CppRefPath(@"<nn/ncm/ncm_ProgramId.h>")]
    [ExternalStruct(8, 8)]
    public struct ProgramId
    {
    }
}

namespace nn.settings
{
    namespace factory
    {
        [CppRefPath(@"<nn/settings/factory/settings_Amiibo.h>")]
        [ExternalStruct(88, 4)]
        public struct AmiiboKey
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_Amiibo.h>")]
        [ExternalStruct(24, 4)]
        public struct AmiiboEcqvCertificate
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_Amiibo.h>")]
        [ExternalStruct(116, 4)]
        public struct AmiiboEcdsaCertificate
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_Amiibo.h>")]
        [ExternalStruct(72, 4)]
        public struct AmiiboEcqvBlsKey
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_Amiibo.h>")]
        [ExternalStruct(36, 4)]
        public struct AmiiboEcqvBlsCertificate
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_Amiibo.h>")]
        [ExternalStruct(148, 4)]
        public struct AmiiboEcqvBlsRootCertificate
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_Bluetooth.h>")]
        [ExternalStruct(6, 1)]
        public struct BdAddress
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_ConfigurationId.h>")]
        [ExternalStruct(30, 1)]
        public struct ConfigurationId1
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_DeviceCertificate.h>")]
        [ExternalStruct(384, 1)]
        [LargeData]
        public struct EccB233DeviceCertificate
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_DeviceCertificate.h>")]
        [ExternalStruct(576, 1)]
        [LargeData]
        public struct Rsa2048DeviceCertificate
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_DeviceKey.h>")]
        [ExternalStruct(88, 4)]
        public struct EccB233DeviceKey
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_DeviceKey.h>")]
        [ExternalStruct(584, 4)]
        [LargeData]
        public struct Rsa2048DeviceKey
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_GameCard.h>")]
        [ExternalStruct(312, 4)]
        [LargeData]
        public struct GameCardKey
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_GameCard.h>")]
        [ExternalStruct(1024, 4)]
        [LargeData]
        public struct GameCardCertificate
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_MotionSensor.h>")]
        [ExternalStruct(6, 2)]
        public struct AccelerometerOffset
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_MotionSensor.h>")]
        [ExternalStruct(6, 2)]
        public struct AccelerometerScale
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_MotionSensor.h>")]
        [ExternalStruct(6, 2)]
        public struct GyroscopeOffset
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_MotionSensor.h>")]
        [ExternalStruct(6, 2)]
        public struct GyroscopeScale
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_WirelessLan.h>")]
        [ExternalStruct(6, 1)]
        public struct MacAddress
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_WirelessLan.h>")]
        [ExternalStruct(3, 1)]
        public struct CountryCode
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_SerialNumber.h>")]
        [ExternalStruct(24, 1)]
        public struct SerialNumber
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_BatteryLot.h>")]
        [ExternalStruct(24, 1)]
        public struct BatteryLot
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_Speaker.h>")]
        [ExternalStruct(90, 2)]
        public struct SpeakerParameter
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_Ssl.h>")]
        [ExternalStruct(312, 4)]
        [LargeData]
        public struct SslKey
        {
        }

        [CppRefPath(@"<nn/settings/factory/settings_Ssl.h>")]
        [ExternalStruct(2052, 4)]
        [LargeData]
        public struct SslCertificate
        {
        }
    }

    public interface IFactorySettingsServer : IServiceObject
    {
        [MethodId(0)]
        Result GetBluetoothBdAddress(Out<factory.BdAddress> outValue);

        [MethodId(1)]
        Result GetConfigurationId1(Out<factory.ConfigurationId1> outValue);

        [MethodId(2)]
        Result GetAccelerometerOffset(
            Out<factory.AccelerometerOffset> outValue);

        [MethodId(3)]
        Result GetAccelerometerScale(Out<factory.AccelerometerScale> outValue);

        [MethodId(4)]
        Result GetGyroscopeOffset(Out<factory.GyroscopeOffset> outValue);

        [MethodId(5)]
        Result GetGyroscopeScale(Out<factory.GyroscopeScale> outValue);

        [MethodId(6)]
        Result GetWirelessLanMacAddress(Out<factory.MacAddress> outValue);

        [MethodId(7)]
        Result GetWirelessLanCountryCodeCount(Out<int32_t> outValue);

        [MethodId(8)]
        Result GetWirelessLanCountryCodes(
            Out<int32_t> outValue,
            OutArray<factory.CountryCode> outCodes);

        [MethodId(9)]
        Result GetSerialNumber(Out<factory.SerialNumber> outValue);

        [MethodId(10)]
        Result SetInitialSystemAppletProgramId(nn.ncm.ProgramId value);

        [MethodId(11)]
        Result SetOverlayDispProgramId(nn.ncm.ProgramId value);

        [MethodId(12)]
        Result GetBatteryLot(Out<factory.BatteryLot> outValue);

        [MethodId(14)]
        Result GetEciDeviceCertificate(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            Out<factory.EccB233DeviceCertificate> outValue);

        [MethodId(15)]
        Result GetEticketDeviceCertificate(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            Out<factory.Rsa2048DeviceCertificate> outValue);

        [MethodId(16)]
        Result GetSslKey(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            Out<factory.SslKey> outValue);

        [MethodId(17)]
        Result GetSslCertificate(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            Out<factory.SslCertificate> outValue);

        [MethodId(18)]
        Result GetGameCardKey(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            Out<factory.GameCardKey> outValue);

        [MethodId(19)]
        Result GetGameCardCertificate(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            Out<factory.GameCardCertificate> outValue);

        [MethodId(20)]
        Result GetEciDeviceKey(
            Out<factory.EccB233DeviceKey> outValue);

        [MethodId(21)]
        Result GetEticketDeviceKey(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            Out<factory.Rsa2048DeviceKey> outValue);

        [MethodId(22)]
        Result GetSpeakerParameter(Out<factory.SpeakerParameter> outValue);

        [MethodId(23)]
        Result GetLcdVendorId(Out<uint32_t> outValue);

        [MethodId(24)]
        Result GetEciDeviceCertificate2(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            Out<factory.Rsa2048DeviceCertificate> outValue);

        [MethodId(25)]
        Result GetEciDeviceKey2(
            [BufferTransferMode(BufferTransferMode.MapAlias)]
            Out<factory.Rsa2048DeviceKey> outValue);

        [MethodId(26)]
        Result GetAmiiboKey(
            Out<factory.AmiiboKey> outValue);

        [MethodId(27)]
        Result GetAmiiboEcqvCertificate(
            Out<factory.AmiiboEcqvCertificate> outValue);

        [MethodId(28)]
        Result GetAmiiboEcdsaCertificate(
            Out<factory.AmiiboEcdsaCertificate> outValue);

        [MethodId(29)]
        Result GetAmiiboEcqvBlsKey(
            Out<factory.AmiiboEcqvBlsKey> outValue);

        [MethodId(30)]
        Result GetAmiiboEcqvBlsCertificate(
            Out<factory.AmiiboEcqvBlsCertificate> outValue);

        [MethodId(31)]
        Result GetAmiiboEcqvBlsRootCertificate(
            Out<factory.AmiiboEcqvBlsRootCertificate> outValue);

        [MethodId(32)]
        Result GetUsbTypeCPowerSourceCircuitVersion(Out<Bit8> outValue);
    }
}
