﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/factory/settings_Result.h>
#include <nn/settings/factory/settings_WirelessLan.h>
#include <nn/settings/system/settings_WirelessLan.h>

#include "detail/settings_WirelessLanImpl.h"

namespace nn { namespace settings { namespace factory {

::nn::Result GetWirelessLanMacAddress(MacAddress* pOutValue) NN_NOEXCEPT
{
    const ::nn::Result result =
        ::nn::settings::detail::GetWirelessLanMacAddress(pOutValue);

    if (!ResultCalibrationDataFileSystemCorrupted::Includes(result) &&
        !ResultCalibrationDataCrcError::Includes(result))
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

::nn::Result GetWirelessLanCountryCodeCount(int* pOutCount) NN_NOEXCEPT
{
    const ::nn::Result result =
        ::nn::settings::detail::GetWirelessLanCountryCodeCount(pOutCount);

    if (!ResultCalibrationDataFileSystemCorrupted::Includes(result) &&
        !ResultCalibrationDataCrcError::Includes(result))
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

::nn::Result GetWirelessLanCountryCodes(int* pOutCount,
                                        CountryCode* pOutCodes,
                                        int count) NN_NOEXCEPT
{

    const ::nn::Result result =
        ::nn::settings::detail::GetWirelessLanCountryCodes(
            pOutCount, pOutCodes, count);

    if (!ResultCalibrationDataFileSystemCorrupted::Includes(result) &&
        !ResultCalibrationDataCrcError::Includes(result))
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

}}} // namespace nn::settings::factory


namespace nn { namespace settings { namespace system {

bool IsWirelessLanEnabled() NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetWirelessLanEnableFlag(&value));
    return value;
}

void SetWirelessLanEnabled(bool enable) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SetWirelessLanEnableFlag(enable));
}

}}} // namespace nn::settings::system
