﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Web.h>

#include "detail/settings_WebImpl.h"

namespace nn { namespace settings { namespace fwdbg {

void SetWebInspectorFlag(bool value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetWebInspectorFlag(value));
}

void SetAllowedSslHosts(
    const ::nn::settings::system::AllowedSslHost values[],
    size_t count) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetAllowedSslHosts(values, count));
}

void SetHostFsMountPoint(
    const ::nn::settings::system::HostFsMountPoint& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetHostFsMountPoint(value));
}

}}} // namespace nn::settings::fwdbg

namespace nn { namespace settings { namespace system {

bool UsesWebInspector() NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetWebInspectorFlag(&value));
    return value;
}

size_t GetAllowedSslHosts(AllowedSslHost outHosts[], size_t count) NN_NOEXCEPT
{
    auto outCount = int32_t();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetAllowedSslHosts(&outCount, outHosts, count));
    return static_cast<size_t>(outCount);
}

void GetHostFsMountPoint(HostFsMountPoint* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetHostFsMountPoint(pOutValue));
}

}}} // namespace nn::settings::system
