﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_TimeZone.h>
#include <nn/time/time_LocationName.h>

#include "detail/settings_TimeZoneImpl.h"

namespace nn { namespace settings { namespace system {

void GetDeviceTimeZoneLocationName(nn::time::LocationName* pOutValue
                                 ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetDeviceTimeZoneLocationName(pOutValue));
}

void SetDeviceTimeZoneLocationName(const nn::time::LocationName& value
                                 ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetDeviceTimeZoneLocationName(value));
}

void GetDeviceTimeZoneLocationUpdatedTime(
    nn::time::SteadyClockTimePoint* pOutValue
    ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetDeviceTimeZoneLocationUpdatedTime(pOutValue));
}

void SetDeviceTimeZoneLocationUpdatedTime(
    const nn::time::SteadyClockTimePoint& value
    ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetDeviceTimeZoneLocationUpdatedTime(value));
}

}}} // namespace nn::settings::system
