﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/settings/factory/settings_Result.h>
#include <nn/settings/factory/settings_Ssl.h>

#include "detail/settings_SslImpl.h"

namespace nn { namespace settings { namespace factory {

::nn::Result GetSslKey(SslKey* pOutValue) NN_NOEXCEPT
{
    const ::nn::Result result = ::nn::settings::detail::GetSslKey(pOutValue);

    if (!ResultCalibrationDataFileSystemCorrupted::Includes(result) &&
        !ResultCalibrationDataCrcError::Includes(result))
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

::nn::Result GetSslCertificate(SslCertificate* pOutValue) NN_NOEXCEPT
{
    const ::nn::Result result =
        ::nn::settings::detail::GetSslCertificate(pOutValue);

    if (!ResultCalibrationDataFileSystemCorrupted::Includes(result) &&
        !ResultCalibrationDataCrcError::Includes(result) &&
        !ResultCalibrationDataShaError::Includes(result))
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

}}} // namespace nn::settings::factory
