﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_Result.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

#include "detail/settings_SettingsGetterApiImpl.h"

namespace nn { namespace settings { namespace fwdbg {

bool IsDebugModeEnabled() NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetDebugModeFlag(&value));
    return value;
}

size_t GetSettingsItemValueSize(const char* name, const char* key) NN_NOEXCEPT
{
    size_t value = 0;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetSettingsItemValueSize(&value, name, key));
    return value;
}

size_t GetSettingsItemValue(void* buffer,
                            size_t bufferSize,
                            const char* name,
                            const char* key) NN_NOEXCEPT
{
    size_t value = 0;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetSettingsItemValue(
            &value, buffer, bufferSize, name, key));
    return value;
}

SettingsItemKeyIterator CreateSettingsItemKeyIterator(const char* name
                                                      ) NN_NOEXCEPT
{
    SettingsItemKeyIterator value = {};
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::CreateSettingsItemKeyIterator(&value, name));
    return value;
}

void DestroySettingsItemKeyIterator(SettingsItemKeyIterator* pIterator
                                    ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::DestroySettingsItemKeyIterator(pIterator));
}

::nn::Result AdvanceSettingsItemKeyIterator(SettingsItemKeyIterator* pIterator
                                            ) NN_NOEXCEPT
{
    ::nn::Result result =
        ::nn::settings::detail::AdvanceSettingsItemKeyIterator(pIterator);

    if (::nn::settings::ResultStopIteration::Includes(result))
    {
        return result;
    }

    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    return result;
}

size_t GetSettingsItemKeySize(const SettingsItemKeyIterator& iterator
                              ) NN_NOEXCEPT
{
    size_t value = 0;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetSettingsItemKeySize(&value, iterator));
    return value;
}

size_t GetSettingsItemKey(void* buffer,
                          size_t bufferSize,
                          const SettingsItemKeyIterator& iterator) NN_NOEXCEPT
{
    size_t value = 0;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetSettingsItemKey(
            &value, buffer, bufferSize, iterator));
    return value;
}

}}} // namespace nn::settings::hwdbg
