﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_ServiceDiscovery.h>

#include "detail/settings_ServiceDiscoveryImpl.h"

namespace nn { namespace settings { namespace system {

void GetServiceDiscoveryControlSettings(ServiceDiscoveryControlSettings* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetServiceDiscoveryControlSettings(pOutValue));
}

void SetServiceDiscoveryControlSettings(const ServiceDiscoveryControlSettings& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::SetServiceDiscoveryControlSettings(value));
}

}}} // namespace nn::settings::system
