﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/settings/settings_Language.h>
#include <nn/settings/system/settings_Language.h>
#include <nn/util/util_StringUtil.h>

#include "detail/settings_LanguageImpl.h"

namespace nn { namespace settings {

bool operator==(const LanguageCode& lhs, const LanguageCode& rhs) NN_NOEXCEPT
{
    return ::nn::util::Strncmp(
        lhs.string, rhs.string, NN_ARRAY_SIZE(rhs.string)) == 0;
}

LanguageCode LanguageCode::Make(Language value) NN_NOEXCEPT
{
    LanguageCode code = {};
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::MakeLanguageCode(&code, value));
    return code;
}

void GetLanguageCode(LanguageCode* pOutValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetLanguageCode(pOutValue));
}

int GetAvailableLanguageCodes(LanguageCode outCodes[], int count) NN_NOEXCEPT
{
    auto codeCount = int32_t();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetAvailableLanguageCodes(&codeCount, outCodes, count));
    return codeCount;
}

int GetAvailableLanguageCodeCount() NN_NOEXCEPT
{
    auto count = int32_t();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::GetAvailableLanguageCodeCount(&count));
    return count;
}

}} // namespace nn::settings

namespace nn { namespace settings { namespace system {

void SetLanguageCode(const LanguageCode& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetLanguageCode(value));
}

}}} // namespace nn::settings::system
