﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/settings/settings_Keyboard.h>
#include <nn/settings/system/settings_Keyboard.h>

#include "detail/settings_KeyboardImpl.h"

namespace nn { namespace settings { namespace system {

KeyboardLayout GetKeyboardLayout() NN_NOEXCEPT
{
    auto value = KeyboardLayout();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetKeyboardLayout(&value));
    return value;
}

void SetKeyboardLayout(KeyboardLayout value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetKeyboardLayout(value));
}

bool GetApplicationOwnKeyboardLayout(KeyboardLayout* pOutValue) NN_NOEXCEPT
{
    auto flag = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetApplicationOwnKeyboardLayout(
            &flag, pOutValue));
    return flag;
}

}}} // namespace nn::settings::system

namespace nn { namespace settings {

void SetApplicationOwnKeyboardLayout(KeyboardLayout value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        detail::SetApplicationOwnKeyboardLayout(value));
}

}} // namespace nn::settings
