﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/settings/settings_DebugPad.h>

#include "detail/settings_DebugPadImpl.h"

namespace nn { namespace settings {

void GetDebugPadGenericPadMap(DebugPadGenericPadMap* outValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetDebugPadGenericPadMap(outValue));
}

void SetDebugPadGenericPadMap(const DebugPadGenericPadMap& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SetDebugPadGenericPadMap(value));
}

void ResetDebugPadGenericPadMap() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::ResetDebugPadGenericPadMap());
}

void GetDebugPadKeyboardMap(DebugPadKeyboardMap* outValue) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::GetDebugPadKeyboardMap(outValue));
}

void SetDebugPadKeyboardMap(const DebugPadKeyboardMap& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::SetDebugPadKeyboardMap(value));
}

void ResetDebugPadKeyboardMap() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::ResetDebugPadKeyboardMap());
}

}} // namespace nn::settings
