﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/settings/factory/settings_Boot.h>
#include <nn/settings/system/settings_Boot.h>

#include "detail/settings_BootImpl.h"

namespace nn { namespace settings { namespace factory {

void SetInitialSystemAppletProgramId(const ::nn::ncm::ProgramId& value
                                     ) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetInitialSystemAppletProgramId(value));
}

void SetOverlayDispProgramId(const ::nn::ncm::ProgramId& value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetOverlayDispProgramId(value));
}

}}} // namespace nn::settings::factory

namespace nn { namespace settings { namespace system {

::nn::ncm::ProgramId GetInitialSystemAppletProgramId() NN_NOEXCEPT
{
    ::nn::ncm::ProgramId value = {};
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetInitialSystemAppletProgramId(&value));
    return value;
}

::nn::ncm::ProgramId GetOverlayDispProgramId() NN_NOEXCEPT
{
    ::nn::ncm::ProgramId value = {};
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetOverlayDispProgramId(&value));
    return value;
}

bool IsInRepairProcess() NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetInRepairProcessEnableFlag(&value));
    return value;
}

void SetInRepairProcessEnabled(bool value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetInRepairProcessEnableFlag(value));
}

bool RequiresRunRepairTimeReviser() NN_NOEXCEPT
{
    auto value = bool();
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetRequiresRunRepairTimeReviser(&value));
    return value;
}

void SetRequiresRunRepairTimeReviser(bool value) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::SetRequiresRunRepairTimeReviser(value));
}

}}} // namespace nn::settings::system
