﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/hid/hid_XpadMap.h>
#include <nn/settings/settings_Xpad.h>

#include "settings_XpadImpl.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetXpadGenericPadMap(BasicXpadGenericPadMap* outValue,
                                  int playerNumber) NN_NOEXCEPT
{
    return ::nn::hid::GetXpadGenericPadMap(outValue, playerNumber);
}

::nn::Result SetXpadGenericPadMap(const BasicXpadGenericPadMap& value,
                                  int playerNumber) NN_NOEXCEPT
{
    return ::nn::hid::SetXpadGenericPadMap(value, playerNumber);
}

::nn::Result ResetXpadGenericPadMap(int playerNumber) NN_NOEXCEPT
{
    return ::nn::hid::ResetXpadGenericPadMap(playerNumber);
}

::nn::Result GetXpadKeyboardMap(BasicXpadKeyboardMap* outValue, int playerNumber
                                ) NN_NOEXCEPT
{
    return ::nn::hid::GetXpadKeyboardMap(outValue, playerNumber);
}

::nn::Result SetXpadKeyboardMap(const BasicXpadKeyboardMap& value,
                                int playerNumber) NN_NOEXCEPT
{
    return ::nn::hid::SetXpadKeyboardMap(value, playerNumber);
}

::nn::Result ResetXpadKeyboardMap(int playerNumber) NN_NOEXCEPT
{
    return ::nn::hid::ResetXpadKeyboardMap(playerNumber);
}

}}} // namespace nn::settings::detail
