﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/settings_IFactorySettingsServer.sfdl.h>
#include <nn/settings/settings_ResultPrivate.h>
#include <nn/settings/factory/settings_WirelessLan.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_Out.h>

#include "settings_WirelessLanImpl.h"
#include "settings_FactorySettingsServer.h"
#include "settings_SystemSettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetWirelessLanMacAddress(
    ::nn::settings::factory::MacAddress* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IFactorySettingsServer> pProxy;
    NN_RESULT_DO(CreateFactorySettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->GetWirelessLanMacAddress(pOutValue));

    NN_RESULT_SUCCESS;
}

::nn::Result GetWirelessLanCountryCodeCount(int* pOutCount) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(pOutCount != nullptr,
                           ResultNullWirelessLanCountryCodeCountBuffer());

    ::nn::sf::SharedPointer<IFactorySettingsServer> pProxy;
    NN_RESULT_DO(CreateFactorySettingsServerProxy(&pProxy));

    int32_t value = 0;
    NN_RESULT_DO(pProxy->GetWirelessLanCountryCodeCount(&value));

    *pOutCount = value;

    NN_RESULT_SUCCESS;
}

::nn::Result GetWirelessLanCountryCodes(
    int* pOutCount,
    ::nn::settings::factory::CountryCode* pOutValues,
    int count) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(pOutCount != nullptr,
                           ResultNullWirelessLanCountryCodeCountBuffer());

    ::nn::sf::SharedPointer<IFactorySettingsServer> pProxy;
    NN_RESULT_DO(CreateFactorySettingsServerProxy(&pProxy));

    int32_t gotCount = 0;
    ::nn::sf::OutArray<::nn::settings::factory::CountryCode
                       > outArray(pOutValues, static_cast<size_t>(count));
    NN_RESULT_DO(pProxy->GetWirelessLanCountryCodes(&gotCount, outArray));

    *pOutCount = gotCount;

    NN_RESULT_SUCCESS;
}

::nn::Result GetWirelessLanEnableFlag(bool *pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetWirelessLanEnableFlag(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetWirelessLanEnableFlag(bool value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetWirelessLanEnableFlag(value));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
