﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <algorithm>
#include <nn/nn_Macro.h>
#include <nn/TargetConfigs/build_Base.h>
#include <nn/util/util_Uuid.h>

#if defined(NN_BUILD_CONFIG_OS_WIN)
#include <nn/nn_Windows.h>
#include <rpc.h>
#endif

#include "settings_Uuid.h"

namespace nn { namespace settings { namespace detail {

::nn::util::Uuid GenerateUuid() NN_NOEXCEPT
{
    ::nn::util::Uuid value = {};
#if !defined(NN_BUILD_CONFIG_OS_WIN)
    value = ::nn::util::GenerateUuid();
#else
    UUID uuid = {};
    ::UuidCreate(&uuid);
    *reinterpret_cast<uint32_t*>(&value.data[0]) = uuid.Data1;
    *reinterpret_cast<uint16_t*>(&value.data[4]) = uuid.Data2;
    *reinterpret_cast<uint16_t*>(&value.data[6]) = uuid.Data3;
    ::std::copy(
        ::std::begin(uuid.Data4), ::std::end(uuid.Data4), &value.data[8]);
#endif
    return value;
}

}}} // namespace nn::settings::detail
