﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/settings/system/settings_Usb.h>
#include <nn/sf/sf_ISharedObject.h>

#include "settings_FactorySettingsServer.h"
#include "settings_SystemSettingsServer.h"
#include "settings_UsbImpl.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetUsb30EnableFlag(bool* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetUsb30EnableFlag(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetUsb30EnableFlag(bool value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetUsb30EnableFlag(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetUsbTypeCPowerSourceCircuitVersion(
    ::nn::Bit8* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IFactorySettingsServer> pProxy;
    NN_RESULT_DO(CreateFactorySettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetUsbTypeCPowerSourceCircuitVersion(pOutValue));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
