﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/time/time_LocationName.h>
#include <nn/time/time_SteadyClockTimePoint.h>

namespace nn { namespace settings { namespace detail {

::nn::Result GetDeviceTimeZoneLocationName(
    ::nn::time::LocationName* pOutValue) NN_NOEXCEPT;

::nn::Result SetDeviceTimeZoneLocationName(
    const ::nn::time::LocationName& value) NN_NOEXCEPT;

::nn::Result GetDeviceTimeZoneLocationUpdatedTime(
    nn::time::SteadyClockTimePoint* pOutValue
    ) NN_NOEXCEPT;

::nn::Result SetDeviceTimeZoneLocationUpdatedTime(
    const nn::time::SteadyClockTimePoint& value
    ) NN_NOEXCEPT;

}}} // namespace nn::settings::detail
