﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/settings/settings_ResultPrivate.h>
#include <nn/sf/sf_ISharedObject.h>

#include "settings_SystemSettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetDeviceTimeZoneLocationName(
    ::nn::time::LocationName* pOutValue) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<ISystemSettingsServer>();
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->GetDeviceTimeZoneLocationName(pOutValue));

    NN_RESULT_SUCCESS;
}

::nn::Result SetDeviceTimeZoneLocationName(
    const ::nn::time::LocationName& value) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<ISystemSettingsServer>();
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->SetDeviceTimeZoneLocationName(value));

    NN_RESULT_SUCCESS;
}

::nn::Result GetDeviceTimeZoneLocationUpdatedTime(
    nn::time::SteadyClockTimePoint* pOutValue
    ) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<ISystemSettingsServer>();
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->GetDeviceTimeZoneLocationUpdatedTime(pOutValue));

    NN_RESULT_SUCCESS;
}

::nn::Result SetDeviceTimeZoneLocationUpdatedTime(
    const nn::time::SteadyClockTimePoint& value
    ) NN_NOEXCEPT
{
    auto pProxy = ::nn::sf::SharedPointer<ISystemSettingsServer>();
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->SetDeviceTimeZoneLocationUpdatedTime(value));

    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
