﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/settings/system/settings_Telemetry.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Out.h>

#include "settings_SystemSettingsServer.h"
#include "settings_TelemetryImpl.h"

namespace nn { namespace settings { namespace detail {

::nn::Result BindTelemetryDirtyFlagEvent(
    ::nn::os::SystemEventType* pEvent,
    ::nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pSystemSettingsServer;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pSystemSettingsServer));
    ::nn::sf::NativeHandle handle;
    NN_RESULT_DO(
        pSystemSettingsServer->AcquireTelemetryDirtyFlagEventHandle(&handle));
    ::nn::os::AttachReadableHandleToSystemEvent(pEvent,
                                                handle.GetOsHandle(),
                                                handle.IsManaged(),
                                                clearMode);
    handle.Detach();
    NN_RESULT_SUCCESS;
}

::nn::Result GetTelemetryDirtyFlags(
    ::nn::settings::system::TelemetryDirtyFlagSet* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pSystemSettingsServer;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pSystemSettingsServer));
    NN_RESULT_DO(pSystemSettingsServer->GetTelemetryDirtyFlags(pOutValue));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
