﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/settings/settings_Language.h>
#include <nn/settings/settings_ServiceTypes.h>
#include <nn/settings/system/settings_Account.h>
#include <nn/settings/system/settings_Backlight.h>
#include <nn/settings/system/settings_BatteryLot.h>
#include <nn/settings/system/settings_BluetoothDevices.h>
#include <nn/settings/system/settings_Clock.h>
#include <nn/settings/system/settings_DataDeletion.h>
#include <nn/settings/system/settings_Eula.h>
#include <nn/settings/system/settings_Fatal.h>
#include <nn/settings/system/settings_FirmwareVersion.h>
#include <nn/settings/system/settings_Hid.h>
#include <nn/settings/system/settings_Mii.h>
#include <nn/settings/system/settings_Network.h>
#include <nn/settings/system/settings_OnlineStorage.h>
#include <nn/settings/system/settings_Ptm.h>
#include <nn/settings/system/settings_SerialNumber.h>
#include <nn/settings/system/settings_ServiceDiscovery.h>
#include <nn/settings/system/settings_SixAxisSensor.h>
#include <nn/settings/system/settings_Sleep.h>
#include <nn/settings/system/settings_SystemApplication.h>
#include <nn/settings/system/settings_Telemetry.h>
#include <nn/settings/system/settings_Web.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/util/util_Uuid.h>

namespace nn { namespace settings { namespace detail {

//!< システム設定サービスを扱うクラスです。
class SystemSettingsServer final
{
    NN_DISALLOW_COPY(SystemSettingsServer);
    NN_DISALLOW_MOVE(SystemSettingsServer);

public:
    SystemSettingsServer() NN_NOEXCEPT;

    ::nn::Result SetLanguageCode(
        ::nn::settings::LanguageCode value) NN_NOEXCEPT;

    ::nn::Result SetNetworkSettings(
        ::nn::sf::InArray<::nn::settings::system::NetworkSettings> values
        ) NN_NOEXCEPT;

    ::nn::Result GetNetworkSettings(
        ::nn::sf::Out<int32_t> outCount,
        ::nn::sf::OutArray<::nn::settings::system::NetworkSettings> outValues
        ) NN_NOEXCEPT;

    ::nn::Result GetFirmwareVersion(
        ::nn::sf::Out<::nn::settings::system::FirmwareVersion> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetFirmwareVersion2(
        ::nn::sf::Out<::nn::settings::system::FirmwareVersion> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetFirmwareVersionDigest(
        ::nn::sf::Out<::nn::settings::system::FirmwareVersionDigest> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetLockScreenFlag(::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetLockScreenFlag(bool value) NN_NOEXCEPT;

    ::nn::Result GetBacklightSettings(
        ::nn::sf::Out<::nn::settings::system::BacklightSettings> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetBacklightSettings(
        const ::nn::settings::system::BacklightSettings& value) NN_NOEXCEPT;

    ::nn::Result SetBluetoothDevicesSettings(
        const ::nn::sf::InArray<
            ::nn::settings::system::BluetoothDevicesSettings>& values
        ) NN_NOEXCEPT;

    ::nn::Result GetBluetoothDevicesSettings(
        ::nn::sf::Out<int32_t> outCount,
        const ::nn::sf::OutArray<
            ::nn::settings::system::BluetoothDevicesSettings>& outValues
        ) NN_NOEXCEPT;

    ::nn::Result GetBluetoothEnableFlag(
        ::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetBluetoothEnableFlag(bool value) NN_NOEXCEPT;

    ::nn::Result GetExternalSteadyClockSourceId(
        ::nn::sf::Out<::nn::settings::system::ClockSourceId> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetExternalSteadyClockSourceId(
        const ::nn::settings::system::ClockSourceId& value) NN_NOEXCEPT;

    ::nn::Result GetShutdownRtcValue(
        ::nn::sf::Out<int64_t> outValue) NN_NOEXCEPT;

    ::nn::Result SetShutdownRtcValue(int64_t value) NN_NOEXCEPT;

    ::nn::Result GetExternalSteadyClockInternalOffset(
        ::nn::sf::Out<int64_t> outValue) NN_NOEXCEPT;

    ::nn::Result SetExternalSteadyClockInternalOffset(
        int64_t value) NN_NOEXCEPT;

    ::nn::Result GetUserSystemClockContext(
        ::nn::sf::Out<::nn::settings::system::SystemClockContext> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetUserSystemClockContext(
        const ::nn::settings::system::SystemClockContext& value) NN_NOEXCEPT;

    ::nn::Result GetNetworkSystemClockContext(
        ::nn::sf::Out<::nn::settings::system::SystemClockContext> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetNetworkSystemClockContext(
        const ::nn::settings::system::SystemClockContext& value) NN_NOEXCEPT;

    ::nn::Result IsUserSystemClockAutomaticCorrectionEnabled(
        ::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetUserSystemClockAutomaticCorrectionEnabled(
        bool value) NN_NOEXCEPT;

    ::nn::Result GetUserSystemClockAutomaticCorrectionUpdatedTime(
        ::nn::sf::Out<::nn::time::SteadyClockTimePoint> outValue) NN_NOEXCEPT;

    ::nn::Result SetUserSystemClockAutomaticCorrectionUpdatedTime(
        const ::nn::time::SteadyClockTimePoint& value) NN_NOEXCEPT;

    ::nn::Result GetAccountSettings(
        ::nn::sf::Out<::nn::settings::system::AccountSettings> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetAccountSettings(
        const ::nn::settings::system::AccountSettings& value) NN_NOEXCEPT;

    ::nn::Result GetAudioVolume(
        ::nn::sf::Out<::nn::settings::system::AudioVolume> outValue,
        int32_t index) NN_NOEXCEPT;

    ::nn::Result SetAudioVolume(
        const ::nn::settings::system::AudioVolume& value,
        int32_t index) NN_NOEXCEPT;

    ::nn::Result GetEulaVersions(
        ::nn::sf::Out<int32_t> outCount,
        ::nn::sf::OutArray<::nn::settings::system::EulaVersion> outValues
        ) NN_NOEXCEPT;

    ::nn::Result SetEulaVersions(
        ::nn::sf::InArray<::nn::settings::system::EulaVersion> values
        ) NN_NOEXCEPT;

    ::nn::Result GetColorSetId(::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT;

    ::nn::Result SetColorSetId(int32_t value) NN_NOEXCEPT;

    ::nn::Result GetConsoleInformationUploadFlag(
        ::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetConsoleInformationUploadFlag(bool value) NN_NOEXCEPT;

    ::nn::Result GetAutomaticApplicationDownloadFlag(
        nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetAutomaticApplicationDownloadFlag(bool value) NN_NOEXCEPT;

    ::nn::Result GetNotificationSettings(
        ::nn::sf::Out<::nn::settings::system::NotificationSettings> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetNotificationSettings(
        const ::nn::settings::system::NotificationSettings& value) NN_NOEXCEPT;

    ::nn::Result GetAccountNotificationSettings(
        ::nn::sf::Out<int32_t> outCount,
        const ::nn::sf::OutArray<
            ::nn::settings::system::AccountNotificationSettings>& outValues
        ) NN_NOEXCEPT;

    ::nn::Result SetAccountNotificationSettings(
        const ::nn::sf::InArray<
            ::nn::settings::system::AccountNotificationSettings>& values
        ) NN_NOEXCEPT;

    ::nn::Result GetVibrationMasterVolume(
        ::nn::sf::Out<float> outValue) NN_NOEXCEPT;

    ::nn::Result SetVibrationMasterVolume(float value) NN_NOEXCEPT;

    ::nn::Result GetSettingsItemValueSize(
        ::nn::sf::Out<uint64_t> outValue,
        const SettingsName& name, const SettingsItemKey& key) NN_NOEXCEPT;

    ::nn::Result GetSettingsItemValue(
        ::nn::sf::Out<uint64_t> outValue, const ::nn::sf::OutBuffer& buffer,
        const SettingsName& name, const SettingsItemKey& key) NN_NOEXCEPT;

    ::nn::Result GetTvSettings(
        ::nn::sf::Out<::nn::settings::system::TvSettings> outValue) NN_NOEXCEPT;

    ::nn::Result SetTvSettings(
        const ::nn::settings::system::TvSettings& value) NN_NOEXCEPT;

    ::nn::Result GetEdid(
        ::nn::sf::Out<::nn::settings::system::Edid> outValue) NN_NOEXCEPT;

    ::nn::Result SetEdid(const ::nn::settings::system::Edid& value) NN_NOEXCEPT;

    ::nn::Result GetAudioOutputMode(
        ::nn::sf::Out<int32_t> outValue, int32_t index) NN_NOEXCEPT;

    ::nn::Result SetAudioOutputMode(int32_t value, int32_t index) NN_NOEXCEPT;

    ::nn::Result IsForceMuteOnHeadphoneRemoved(
        ::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetForceMuteOnHeadphoneRemoved(bool value) NN_NOEXCEPT;

    ::nn::Result GetQuestFlag(::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetQuestFlag(bool value) NN_NOEXCEPT;

    ::nn::Result GetDataDeletionSettings(
        ::nn::sf::Out<::nn::settings::system::DataDeletionSettings> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetDataDeletionSettings(
        ::nn::settings::system::DataDeletionSettings value) NN_NOEXCEPT;

    ::nn::Result GetInitialSystemAppletProgramId(
        ::nn::sf::Out<::nn::ncm::ProgramId> outValue) NN_NOEXCEPT;

    ::nn::Result GetOverlayDispProgramId(
        ::nn::sf::Out<nn::ncm::ProgramId> outValue) NN_NOEXCEPT;

    ::nn::Result GetDeviceTimeZoneLocationName(
        ::nn::sf::Out<::nn::time::LocationName> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetDeviceTimeZoneLocationName(
        const ::nn::time::LocationName& value
        ) NN_NOEXCEPT;

    ::nn::Result GetDeviceTimeZoneLocationUpdatedTime(
        ::nn::sf::Out<::nn::time::SteadyClockTimePoint> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetDeviceTimeZoneLocationUpdatedTime(
        const ::nn::time::SteadyClockTimePoint& value
        ) NN_NOEXCEPT;

    ::nn::Result GetWirelessCertificationFileSize(
        ::nn::sf::Out<uint64_t> outValue) NN_NOEXCEPT;

    ::nn::Result GetWirelessCertificationFile(
        ::nn::sf::Out<uint64_t> outValue,
        const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;

    ::nn::Result SetRegionCode(int32_t value) NN_NOEXCEPT;

    ::nn::Result GetDebugModeFlag(::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result GetPrimaryAlbumStorage(
        ::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT;

    ::nn::Result SetPrimaryAlbumStorage(int32_t value) NN_NOEXCEPT;

    ::nn::Result GetUsb30EnableFlag(::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetUsb30EnableFlag(bool value) NN_NOEXCEPT;

    ::nn::Result GetBatteryLot(
        ::nn::sf::Out<::nn::settings::system::BatteryLot> outValue) NN_NOEXCEPT;

    ::nn::Result GetSerialNumber(
        ::nn::sf::Out<::nn::settings::system::SerialNumber> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetNfcEnableFlag(::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetNfcEnableFlag(bool value) NN_NOEXCEPT;

    ::nn::Result GetSleepSettings(
        ::nn::sf::Out<::nn::settings::system::SleepSettings> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetSleepSettings(
        const ::nn::settings::system::SleepSettings& value) NN_NOEXCEPT;

    ::nn::Result GetWirelessLanEnableFlag(
        ::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetWirelessLanEnableFlag(bool value) NN_NOEXCEPT;

    ::nn::Result GetInitialLaunchSettings(
        ::nn::sf::Out<::nn::settings::system::InitialLaunchSettings> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetInitialLaunchSettings(
        const ::nn::settings::system::InitialLaunchSettings& value) NN_NOEXCEPT;

    ::nn::Result GetDeviceNickName(
        ::nn::sf::Out<::nn::settings::system::DeviceNickName> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetDeviceNickName(
        const ::nn::settings::system::DeviceNickName& value) NN_NOEXCEPT;

    ::nn::Result GetProductModel(::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT;

    ::nn::Result GetLdnChannel(::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT;

    ::nn::Result SetLdnChannel(int32_t value) NN_NOEXCEPT;

    ::nn::Result AcquireTelemetryDirtyFlagEventHandle(
        ::nn::sf::Out<::nn::sf::NativeHandle> outValue) NN_NOEXCEPT;

    ::nn::Result GetTelemetryDirtyFlags(
        ::nn::sf::Out<::nn::settings::system::TelemetryDirtyFlagSet> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetPtmBatteryLot(
        ::nn::sf::Out<::nn::settings::system::PtmBatteryLot> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetPtmBatteryLot(
        const nn::settings::system::PtmBatteryLot& value) NN_NOEXCEPT;

    ::nn::Result GetPtmFuelGaugeParameter(
        ::nn::sf::Out<::nn::settings::system::PtmFuelGaugeParameter> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetPtmFuelGaugeParameter(
        const ::nn::settings::system::PtmFuelGaugeParameter& value) NN_NOEXCEPT;

    ::nn::Result GetMiiAuthorId(
        ::nn::sf::Out<::nn::util::Uuid> outValue) NN_NOEXCEPT;

    ::nn::Result AcquireFatalDirtyFlagEventHandle(
        ::nn::sf::Out<::nn::sf::NativeHandle> outValue) NN_NOEXCEPT;

    ::nn::Result GetFatalDirtyFlags(
        ::nn::sf::Out<::nn::settings::system::FatalDirtyFlagSet> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetAutoUpdateEnableFlag(
        ::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetAutoUpdateEnableFlag(bool value) NN_NOEXCEPT;

    ::nn::Result GetNxControllerSettings(
        ::nn::sf::Out<std::int32_t> outCount,
        const ::nn::sf::OutArray<::nn::settings::system::NxControllerSettings
            >& outValues) NN_NOEXCEPT;

    ::nn::Result SetNxControllerSettings(
        const ::nn::sf::InArray<::nn::settings::system::NxControllerSettings
            >& values) NN_NOEXCEPT;

    ::nn::Result GetBatteryPercentageFlag(
        ::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetBatteryPercentageFlag(bool value) NN_NOEXCEPT;

    ::nn::Result GetExternalRtcResetFlag(
        ::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetExternalRtcResetFlag(bool value) NN_NOEXCEPT;

    ::nn::Result GetUsbFullKeyEnableFlag(
        ::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetUsbFullKeyEnableFlag(bool value) NN_NOEXCEPT;

    ::nn::Result GetBacklightSettingsEx(
        ::nn::sf::Out<::nn::settings::system::BacklightSettingsEx> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetBacklightSettingsEx(
        const ::nn::settings::system::BacklightSettingsEx& value) NN_NOEXCEPT;

    ::nn::Result GetHeadphoneVolumeWarningCount(
        ::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT;

    ::nn::Result SetHeadphoneVolumeWarningCount(int32_t value) NN_NOEXCEPT;

    ::nn::Result GetBluetoothAfhEnableFlag(
        ::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetBluetoothAfhEnableFlag(bool value) NN_NOEXCEPT;

    ::nn::Result GetBluetoothBoostEnableFlag(
        ::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetBluetoothBoostEnableFlag(bool value) NN_NOEXCEPT;

    ::nn::Result GetInRepairProcessEnableFlag(
        ::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetInRepairProcessEnableFlag(bool value) NN_NOEXCEPT;

    ::nn::Result GetHeadphoneVolumeUpdateFlag(
        ::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetHeadphoneVolumeUpdateFlag(bool value) NN_NOEXCEPT;

    ::nn::Result NeedsToUpdateHeadphoneVolume(
        ::nn::sf::Out<bool> outValue,
        ::nn::sf::Out<bool> outIsHighPowerAvailable,
        ::nn::sf::Out<int8_t> outVolume,
        bool isRestricted) NN_NOEXCEPT;

    ::nn::Result GetPushNotificationActivityModeOnSleep(
        ::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT;

    ::nn::Result SetPushNotificationActivityModeOnSleep(
        int32_t value) NN_NOEXCEPT;

    ::nn::Result GetServiceDiscoveryControlSettings(
        ::nn::sf::Out<
            ::nn::settings::system::ServiceDiscoveryControlSettings> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetServiceDiscoveryControlSettings(
        const nn::settings::system::ServiceDiscoveryControlSettings& value
        ) NN_NOEXCEPT;

    ::nn::Result GetErrorReportSharePermission(
        ::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT;

    ::nn::Result SetErrorReportSharePermission(int32_t value) NN_NOEXCEPT;

    ::nn::Result GetAppletLaunchFlags(
        ::nn::sf::Out<::nn::settings::system::AppletLaunchFlagSet> outValue
        ) NN_NOEXCEPT;

    ::nn::Result SetAppletLaunchFlags(
        ::nn::settings::system::AppletLaunchFlagSet value) NN_NOEXCEPT;

    ::nn::Result GetConsoleSixAxisSensorAccelerationBias(
        ::nn::sf::Out<
            ::nn::settings::system::ConsoleSixAxisSensorAccelerationBias
            > outValue) NN_NOEXCEPT;

    ::nn::Result SetConsoleSixAxisSensorAccelerationBias(
        const ::nn::settings::system::
            ConsoleSixAxisSensorAccelerationBias& value) NN_NOEXCEPT;

    ::nn::Result GetConsoleSixAxisSensorAngularVelocityBias(
        ::nn::sf::Out<
            ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityBias
            > outValue) NN_NOEXCEPT;

    ::nn::Result SetConsoleSixAxisSensorAngularVelocityBias(
        const ::nn::settings::system::
            ConsoleSixAxisSensorAngularVelocityBias& value) NN_NOEXCEPT;

    ::nn::Result GetConsoleSixAxisSensorAccelerationGain(
        ::nn::sf::Out<
            ::nn::settings::system::ConsoleSixAxisSensorAccelerationGain
            > outValue) NN_NOEXCEPT;

    ::nn::Result SetConsoleSixAxisSensorAccelerationGain(
        const ::nn::settings::system::
            ConsoleSixAxisSensorAccelerationGain& value) NN_NOEXCEPT;

    ::nn::Result GetConsoleSixAxisSensorAngularVelocityGain(
        ::nn::sf::Out<
            ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityGain
            > outValue) NN_NOEXCEPT;

    ::nn::Result SetConsoleSixAxisSensorAngularVelocityGain(
        const ::nn::settings::system::
            ConsoleSixAxisSensorAngularVelocityGain& value) NN_NOEXCEPT;

    ::nn::Result GetConsoleSixAxisSensorAngularVelocityTimeBias(
        ::nn::sf::Out<
            ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityTimeBias
            > outValue) NN_NOEXCEPT;

    ::nn::Result SetConsoleSixAxisSensorAngularVelocityTimeBias(
        const ::nn::settings::system::
            ConsoleSixAxisSensorAngularVelocityTimeBias& value) NN_NOEXCEPT;

    ::nn::Result GetConsoleSixAxisSensorAngularAcceleration(
        ::nn::sf::Out<
            ::nn::settings::system::ConsoleSixAxisSensorAngularAcceleration
            > outValue) NN_NOEXCEPT;

    ::nn::Result SetConsoleSixAxisSensorAngularAcceleration(
        const ::nn::settings::system::
            ConsoleSixAxisSensorAngularAcceleration& value) NN_NOEXCEPT;

    ::nn::Result GetKeyboardLayout(::nn::sf::Out<int32_t> outValue) NN_NOEXCEPT;

    ::nn::Result SetKeyboardLayout(int32_t value) NN_NOEXCEPT;

    ::nn::Result GetWebInspectorFlag(::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result GetAllowedSslHosts(
        ::nn::sf::Out<int32_t> outCount,
        const ::nn::sf::OutArray<::nn::settings::system::AllowedSslHost>&
            outValues) NN_NOEXCEPT;

    ::nn::Result GetHostFsMountPoint(
        ::nn::sf::Out<::nn::settings::system::HostFsMountPoint> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetRequiresRunRepairTimeReviser(
        ::nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    ::nn::Result SetRequiresRunRepairTimeReviser(bool value) NN_NOEXCEPT;

    ::nn::Result SetBlePairingSettings(
        const ::nn::sf::InArray<
            ::nn::settings::system::BlePairingSettings>& values) NN_NOEXCEPT;

    ::nn::Result GetBlePairingSettings(
        ::nn::sf::Out<int32_t> outCount,
        const ::nn::sf::OutArray<
            ::nn::settings::system::BlePairingSettings>& outValues) NN_NOEXCEPT;

    ::nn::Result GetRebootlessSystemUpdateVersion(
        ::nn::sf::Out<
            ::nn::settings::system::RebootlessSystemUpdateVersion> outValue
        ) NN_NOEXCEPT;

    ::nn::Result GetAccountOnlineStorageSettings(
        ::nn::sf::Out<int32_t> outCount,
        const ::nn::sf::OutArray<
            ::nn::settings::system::AccountOnlineStorageSettings>& outValues
        ) NN_NOEXCEPT;

    ::nn::Result SetAccountOnlineStorageSettings(
        const ::nn::sf::InArray<
            ::nn::settings::system::AccountOnlineStorageSettings>& values
        ) NN_NOEXCEPT;
};

//!< システム設定サービスのプロクシを作成します。
::nn::Result CreateSystemSettingsServerProxy(
    ::nn::sf::SharedPointer<ISystemSettingsServer>* pOutValue) NN_NOEXCEPT;

}}}
