﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/ncm/ncm_SystemContentMetaId.h>
#include <nn/result/result_HandlingUtility.h>

#include "settings_SystemData-os.win.h"
#include "settings_SystemDataFile-os.win.h"

namespace nn { namespace settings { namespace detail {

namespace {

//!< ファイル名のプレフィックス
const char FileNamePrefix[] = "Nintendo_SystemData_";

} // namespace

SystemData::SystemData() NN_NOEXCEPT
{
    m_SystemDataFile.SetPrefix(FileNamePrefix);
}

const SystemDataFile& SystemData::GetSystemDataFile() const NN_NOEXCEPT
{
    return m_SystemDataFile;
}

void SystemData::SetSystemDataId(::nn::ncm::SystemDataId value) NN_NOEXCEPT
{
    NN_UNUSED(value);
}

void SystemData::SetMountName(const char* name) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(name);
    m_SystemDataFile.SetMountName(name);
}

::nn::Result SystemData::Mount() NN_NOEXCEPT
{
    NN_RESULT_DO(m_SystemDataFile.Mount(false));
    NN_RESULT_SUCCESS;
}

::nn::Result SystemData::OpenToRead() NN_NOEXCEPT
{
    NN_RESULT_DO(m_SystemDataFile.OpenToRead());
    NN_RESULT_SUCCESS;
}

void SystemData::Close() NN_NOEXCEPT
{
    m_SystemDataFile.Close();
}

::nn::Result SystemData::Read(
    int64_t offset, void* buffer, size_t size) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(buffer);
    NN_RESULT_DO(m_SystemDataFile.Read(offset, buffer, size));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
