﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/spl/spl_Api.h>

#include "settings_Spl.h"

namespace nn { namespace settings { namespace detail {

namespace {

//!< spl の保持する情報を表す構造体です。
struct SplInfo final
{
    bool isDevelopment;
    ::nn::spl::HardwareType hardwareType;
    ::nn::spl::RetailInteractiveDisplayState retailInteractiveDisplayState;
};

//!< spl の保持する情報を返します。
const SplInfo& GetSplInfo() NN_NOEXCEPT;

} // namespace

bool IsSplDevelopment() NN_NOEXCEPT
{
    return GetSplInfo().isDevelopment;
}

SplHardwareType GetSplHardwareType() NN_NOEXCEPT
{
    switch (GetSplInfo().hardwareType)
    {
    case ::nn::spl::HardwareType_Icosa:
        return SplHardwareType::Icosa;
    case ::nn::spl::HardwareType_Copper:
        return SplHardwareType::Copper;
    case ::nn::spl::HardwareType_Hoag:
        return SplHardwareType::Hoag;
    case ::nn::spl::HardwareType_Iowa:
        return SplHardwareType::IcosaMariko;
    default: NN_UNEXPECTED_DEFAULT;
    }
}

bool IsSplRetailInteractiveDisplayStateEnabled() NN_NOEXCEPT
{
    switch (GetSplInfo().retailInteractiveDisplayState)
    {
    case ::nn::spl::RetailInteractiveDisplayState_Disabled:
        return false;
    case ::nn::spl::RetailInteractiveDisplayState_Enabled:
        return true;
    default: NN_UNEXPECTED_DEFAULT;
    }
}

namespace {

const SplInfo& GetSplInfo() NN_NOEXCEPT
{
    static SplInfo s_SplInfo = {};

    static bool s_IsInitialized = false;

    if (!s_IsInitialized)
    {
        ::nn::spl::Initialize();

        s_SplInfo.isDevelopment =
            ::nn::spl::IsDevelopment();

        s_SplInfo.hardwareType =
            ::nn::spl::GetHardwareType();

        s_SplInfo.retailInteractiveDisplayState =
            ::nn::spl::GetRetailInteractiveDisplayState();

        ::nn::spl::Finalize();

        s_IsInitialized = true;
    }

    return s_SplInfo;
}

} // namespace

}}} // namespace nn::settings::detail
