﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/settings/system/settings_SixAxisSensor.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_Out.h>

#include "settings_SixAxisSensorImpl.h"
#include "settings_SystemSettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetConsoleSixAxisSensorAccelerationBias(
    ::nn::settings::system::ConsoleSixAxisSensorAccelerationBias* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->GetConsoleSixAxisSensorAccelerationBias(pOutValue));

    NN_RESULT_SUCCESS;
}

::nn::Result SetConsoleSixAxisSensorAccelerationBias(
    const ::nn::settings::system::ConsoleSixAxisSensorAccelerationBias& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->SetConsoleSixAxisSensorAccelerationBias(value));

    NN_RESULT_SUCCESS;
}

::nn::Result GetConsoleSixAxisSensorAngularVelocityBias(
    ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityBias* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->GetConsoleSixAxisSensorAngularVelocityBias(pOutValue));

    NN_RESULT_SUCCESS;
}

::nn::Result SetConsoleSixAxisSensorAngularVelocityBias(
    const ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityBias& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->SetConsoleSixAxisSensorAngularVelocityBias(value));

    NN_RESULT_SUCCESS;
}

::nn::Result GetConsoleSixAxisSensorAccelerationGain(
    ::nn::settings::system::ConsoleSixAxisSensorAccelerationGain* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->GetConsoleSixAxisSensorAccelerationGain(pOutValue));

    NN_RESULT_SUCCESS;
}

::nn::Result SetConsoleSixAxisSensorAccelerationGain(
    const ::nn::settings::system::ConsoleSixAxisSensorAccelerationGain& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->SetConsoleSixAxisSensorAccelerationGain(value));

    NN_RESULT_SUCCESS;
}

::nn::Result GetConsoleSixAxisSensorAngularVelocityGain(
    ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityGain* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->GetConsoleSixAxisSensorAngularVelocityGain(pOutValue));

    NN_RESULT_SUCCESS;
}

::nn::Result SetConsoleSixAxisSensorAngularVelocityGain(
    const ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityGain& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->SetConsoleSixAxisSensorAngularVelocityGain(value));

    NN_RESULT_SUCCESS;
}


::nn::Result GetConsoleSixAxisSensorAngularVelocityTimeBias(
    ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityTimeBias* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->GetConsoleSixAxisSensorAngularVelocityTimeBias(pOutValue));

    NN_RESULT_SUCCESS;
}

::nn::Result SetConsoleSixAxisSensorAngularVelocityTimeBias(
    const ::nn::settings::system::ConsoleSixAxisSensorAngularVelocityTimeBias& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->SetConsoleSixAxisSensorAngularVelocityTimeBias(value));

    NN_RESULT_SUCCESS;
}

::nn::Result GetConsoleSixAxisSensorAngularAcceleration(
    ::nn::settings::system::ConsoleSixAxisSensorAngularAcceleration* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->GetConsoleSixAxisSensorAngularAcceleration(pOutValue));

    NN_RESULT_SUCCESS;
}

::nn::Result SetConsoleSixAxisSensorAngularAcceleration(
    const ::nn::settings::system::ConsoleSixAxisSensorAngularAcceleration& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));

    NN_RESULT_DO(pProxy->SetConsoleSixAxisSensorAngularAcceleration(value));

    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
