﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/settings_IFirmwareDebugSettingsServer.sfdl.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_Out.h>

#include "settings_FirmwareDebugSettingsServer.h"
#include "settings_SettingsManagementImpl.h"

namespace nn { namespace settings { namespace detail {

::nn::Result ReadSettings(
    uint64_t* pOutCount, ::nn::Bit8 buffer[], size_t count, int32_t target
    ) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IFirmwareDebugSettingsServer> pProxy;
    NN_RESULT_DO(CreateFirmwareDebugSettingsServerProxy(&pProxy));
    ::nn::sf::OutBuffer outBuffer(reinterpret_cast<char*>(buffer), count);
    NN_RESULT_DO(pProxy->ReadSettings(pOutCount, outBuffer, target));
    NN_RESULT_SUCCESS;
}

::nn::Result ResetSettings(int32_t target) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<IFirmwareDebugSettingsServer> pProxy;
    NN_RESULT_DO(CreateFirmwareDebugSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->ResetSettings(target));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
