﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/system/settings_Ptm.h>

namespace nn { namespace settings { namespace detail {

::nn::Result GetPtmBatteryLot(
    ::nn::settings::system::PtmBatteryLot* pOutValue) NN_NOEXCEPT;

::nn::Result SetPtmBatteryLot(
    const ::nn::settings::system::PtmBatteryLot& value) NN_NOEXCEPT;

::nn::Result GetPtmFuelGaugeParameter(
    ::nn::settings::system::PtmFuelGaugeParameter* pOutValue) NN_NOEXCEPT;

::nn::Result SetPtmFuelGaugeParameter(
    const ::nn::settings::system::PtmFuelGaugeParameter& value) NN_NOEXCEPT;

}}} // namespace nn::settings::detail
