﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_ISystemSettingsServer.sfdl.h>
#include <nn/settings/system/settings_Ptm.h>
#include <nn/sf/sf_ISharedObject.h>

#include "settings_PtmImpl.h"
#include "settings_SystemSettingsServer.h"

namespace nn { namespace settings { namespace detail {

::nn::Result GetPtmBatteryLot(
    ::nn::settings::system::PtmBatteryLot* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetPtmBatteryLot(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetPtmBatteryLot(
    const ::nn::settings::system::PtmBatteryLot& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetPtmBatteryLot(value));
    NN_RESULT_SUCCESS;
}

::nn::Result GetPtmFuelGaugeParameter(
    ::nn::settings::system::PtmFuelGaugeParameter* pOutValue) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->GetPtmFuelGaugeParameter(pOutValue));
    NN_RESULT_SUCCESS;
}

::nn::Result SetPtmFuelGaugeParameter(
    const ::nn::settings::system::PtmFuelGaugeParameter& value) NN_NOEXCEPT
{
    ::nn::sf::SharedPointer<ISystemSettingsServer> pProxy;
    NN_RESULT_DO(CreateSystemSettingsServerProxy(&pProxy));
    NN_RESULT_DO(pProxy->SetPtmFuelGaugeParameter(value));
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::settings::detail
